//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
// AssemblyDoc.cpp : plik implementacji
//

#include "stdafx.h"
#include "MDI.h"
#include "AssemblyDoc.h"


// CAssemblyDoc

IMPLEMENT_DYNCREATE(CAssemblyDoc, CDocument)

CAssemblyDoc::CAssemblyDoc()
{
	m_pImport = NULL;
	m_pDisp = NULL;
	HRESULT hr = CoCreateInstance(CLSID_CorMetaDataDispenser, NULL, CLSCTX_INPROC_SERVER, 
                                  IID_IMetaDataDispenserEx, (void **) &m_pDisp);
	hFile = INVALID_HANDLE_VALUE;
	hFileMap = NULL;
	pData = NULL;
}

CAssemblyDoc::~CAssemblyDoc()
{
	if(m_pImport != NULL)
		m_pImport->Release();
	if(m_pDisp != NULL)
		m_pDisp->Release();
	m_pImport = NULL;
	m_pDisp = NULL;

	if(pData != NULL)
		UnmapViewOfFile(pData);
	pData = NULL;
	if(hFileMap != NULL)
		CloseHandle(hFileMap);
	hFileMap = NULL;
	if(hFile != INVALID_HANDLE_VALUE)
		CloseHandle(hFile);
	hFile = INVALID_HANDLE_VALUE;
}


BEGIN_MESSAGE_MAP(CAssemblyDoc, CDocument)
END_MESSAGE_MAP()


// Diagnostyka CAssemblyDoc

#ifdef _DEBUG
void CAssemblyDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CAssemblyDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG


// Serializacja CAssemblyDoc

void CAssemblyDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: dodanie kodu zapisujcego
	}
	else
	{
		// TODO: dodanie kodu adujcego
	}
}


// Polecenia CAssemblyDoc

BOOL CAssemblyDoc::OnOpenDocument(LPCTSTR lpszPathName)
{
	if (!CDocument::OnOpenDocument(lpszPathName))
		return FALSE;
	
    WCHAR szScope[1024];
	wcscpy(szScope, L"file:");
    wcscat(szScope, lpszPathName);

    // Prba otwarcia zakresu dla danego pliku.
    HRESULT hr = m_pDisp->OpenScope(szScope, 0, IID_IMetaDataImport, (IUnknown**)&m_pImport);

	m_sAssemblyPath = lpszPathName;

	hFile = CreateFile(lpszPathName,			// cieka pliku.
		               GENERIC_READ,			// dany rodzaj dostpu.
					   FILE_SHARE_READ,			// Tryb udostpniania.
					   NULL,					// Atrybuty zabezpiecze.
					   OPEN_EXISTING,			// Sposb tworzenia.
					   FILE_ATTRIBUTE_NORMAL,	// 
					   NULL);					//

	if(hFile == INVALID_HANDLE_VALUE)
	{
		return FALSE;
	}

	hFileMap = CreateFileMapping(hFile,			// Uchwyt pliku (z CreateFile).
	                             NULL,			// Atrybuty zabezpiecze.
								 PAGE_READONLY,	// Atrybut ochrony.
								 0, 0,			// Wielko.
								 NULL);			// Nazwa mapy.
	if(hFileMap == NULL)
	{
		return FALSE;
	}

	pData = (PBYTE)MapViewOfFile(hFileMap,		// File mapping object
		                         FILE_MAP_READ, // Desired access
								 0, 0, 0);		// Offset and size
	if(pData == NULL)
	{
		return FALSE;
	}

	return TRUE;
}
